﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3		// Use modern global access method and strict wave access.
#pragma hide=1

// uncomment to debug
//#define DEBUG

// ***
// PANEL CONTROL FUNCTIONS

// tab procedure
Function X_TabProc(tca) : TabControl
	STRUCT WMTabControlAction &tca

	variable ctab
	string tablist, ptab
	
	switch( tca.eventCode )
		case 2: // mouse up
			ctab = tca.tab

#ifndef DEBUG
			// no switching to other tabs until an image is loaded
			if (!f_ImageLoaded())
				TabControl tab_main, win=$k_fullpanel, value = 0
				return 0
			endif
#endif
			// do nothing if the same tab
			ptab = GetUserData(k_fullpanel,"tab_main","ptab")
			if (str2num(ptab)==ctab)
				return 0
			endif
			
			// switch tabs
			disp_SwitchTab(ptab,ctab)
			
			break
	endswitch
	
	return 0
end

// button control procedure
Function X_ButtonProc(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	
	variable nimgs, brkout
	variable method, level, mask, stZ
	variable shiftkey, optionkey
	
	switch( ba.eventCode )
		case 2: // mouse up
			// click code here
			strswitch(ba.ctrlName)
				// control bar
				case "buttonExpand_CB":
					toggle_DisplaySize(ba)
					break
				case "buttonSwap_CB":
					Swap_SpitViewImages()
					break
				case "buttonResetIRange_CB":
					switch (ba.eventMod)
						case 2:		// shift key
							Slider sliderIMax_CB, win=$k_imgDisplay, value=1
							level = Change_DisImageBitDepth(1)
							move_HistCursor(1,level)
							break
						case 4:		// alt/option key
							Slider sliderIMin_CB, win=$k_imgDisplay, value=0
							level = Change_DisImageBitDepth(-1)
							move_HistCursor(-1,level)
							break
						default:
							Slider sliderIMin_CB, win=$k_imgDisplay, value=0
							Slider sliderIMax_CB, win=$k_imgDisplay, value=1
							level = Change_DisImageBitDepth(-1)
							move_HistCursor(-1,level)
							level = Change_DisImageBitDepth(1)
							move_HistCursor(1,level)
							break
					endswitch
					break
				case "buttonSplitRoB_CB":
					method = str2num(GetUserData("","buttonSplitRoB_CB","mode"))
					switch(method)
						case 0:
							Button buttonSplitRoB_CB, win=$k_imgDisplay, title="v", userdata(mode)="1"
							break
						case 1:
							Button buttonSplitRoB_CB, win=$k_imgDisplay, title=">", userdata(mode)="0"
							break
					endswitch
					break
				// histogram
				case "buttonhelp_hist":
					open_ImgToolsHelp("Histograms")
					break
				// tab M
				case "buttonImgL_tabM":
					disp_SetImagePanelSide(0)
					break
				case "buttonImgR_tabM":
					disp_SetImagePanelSide(1)
					break
				case "buttonleft_tabM":
					disp_SplitWindow(0)
					step_ThruImages(-1)	
					disp_UpdatePanelControls(-1)
					ControlInfo/W=$k_fullpanel tab_main
					disp_UpdatePanelControls(v_value)
					T3_UpdateContactPrint()
					break
				case "buttonright_tabM":
					disp_SplitWindow(0)
					step_ThruImages(1)
					disp_UpdatePanelControls(-1)
					ControlInfo/W=$k_fullpanel tab_main
					disp_UpdatePanelControls(v_value)
					T3_UpdateContactPrint()
					break
				case "buttonRedoH_tabM":
					disp_UpdateHistograms()
					break
				// tab 0
				case "buttonLoad_tab0":
					nimgs = f_NImagesLoaded()
					ControlInfo/W=$k_fullpanel popupload_tab0
					switch(v_value)
						case 1:	// one or multiple files
							brkout = T0_LoadImages(0)
							break
						case 2:	// a folder
							brkout = T0_LoadImages(1)
							break
						case 3:	// a stack
							brkout = T0_LoadStackTiffimgs()
							break
						case 4:	// internal data folder
							brkout = T0_ConvertDataFolders()
							break
						default:	// user defined loaders
							brkout = imgT_UserLoader("imgTLoader_" + S_value)
							break
					endswitch
					if (brkout < 0)
						return -1
					endif
					// replace image if this is the first
					if (nimgs == 0)
						step_ThruImages(0)
						T3_UpdateContactPrint()
						disp_InitializeTabMenus(100)
					else
						step_ThruImages(0)
						//disp_UpdatePanelControls(-1)
					endif
					ControlUpdate/A/W=$k_fullpanel
					break
				case "buttondoMovie_tabM":
					ControlInfo/W=$k_fullPanel setvarsleep_tabM
					play_Stack(v_value)
					break
				// tab 1
				case "buttonSetXY_tab1":
					T1_SetXY()
					disp_UpdatePanelControls(1)
					ControlInfo/W=$k_fullPanel popupScaleBar_tab3
					if (v_value  > 1)
						disp_ShowScaleBar(v_value - 1)
					endif
					break
				case "buttonclearlocalscale_tab1":
					T1_ClearXYScale(1)
					disp_UpdatePanelControls(1)
					ControlInfo/W=$k_fullPanel popupScaleBar_tab3
					if (v_value > 1)
						disp_ShowScaleBar(v_value - 1)
					endif
					break
				case "buttonclearglobalscale_tab1":
					T1_ClearXYScale(0)
					disp_UpdatePanelControls(1)
					ControlInfo/W=$k_fullPanel popupScaleBar_tab3
					if (v_value  > 1)
						disp_ShowScaleBar(v_value - 1)
					endif
					break
				case "buttonSetcalI_tab1":
					T1_CalibrateIntensity()
					//disp_UpdatePanelControls(-1)
					disp_UpdatePanelControls(1)
					disp_UpdateHistograms()
					break
				// tab 21
				case "buttonsetbckgrnd_tab21":
					//ControlInfo/W=$k_fullPanel popupBckgHow_tab21
					T21_SetBackgroundPoints()
					//disp_UpdatePanelControls(2)
					break
				case "buttoneditbckpoints_tab21":
					T21_EditBackgroundPoints()
					break
				case "buttonclearbckpoints_tab21":
					T21_ClearBackgroundPoints()
					disp_UpdatePanelControls(2)
					break
				case "buttonRemoveBckg_tab21":
					T21_RemoveBackground()
					T21_ShowBackground()
					disp_UpdatePanelControls(2)
					print_imgTReport()
					break
				case "buttonRestoreBckpoints_tab21":
					T21_RestoreBackgroundPoints()
					disp_UpdatePanelControls(2)
					break
				// tab 22
				case "buttondoThreshold_tab22":
					T22_StartThreshold()
					T22_ShowThreshold()
					disp_UpdatePanelControls(2)
					print_imgTReport()
					break
				case "buttonFillThreshold_tab22":
					T22_FillThreshold()
					T22_ShowFill()
					disp_UpdatePanelControls(2)
					break
				case "buttonShowThStats_tab22":
					T22_ShowThesholdStats()
					break
				// tab 23
				case "buttonstartRoIMask_tab23":
					T2_StartMaskDrawing()
					disp_UpdateTab23()
					break
				case "buttonstopRoIMask_tab23":
					T2_StopMaskDrawing()
					disp_UpdateTab23()
					break
				case "buttonclearRoIMask_tab23":
					T2_ClearMaskRoIs()
					disp_UpdateTab23()
					break
				case "buttonDoMaskOP_tab23":
					T2_DoMaskOP()
					T2_ShowMasked()
					break
				// tab 24 - do math on stack
				case "buttonDoMaS_tab24":
					T2_DoMAs()
//					disp_UpdatePanelControls(2)
//					disp_UpdatePanelControls(-1)
					break
				case "buttonDoSpMa_tab25":
					T2_DoSplitMath()
//					disp_UpdatePanelControls(2)
//					disp_UpdatePanelControls(-1)
					break
				case "buttonCropIt_tab26":
					T2_CropIt()
					disp_UpdatePanelControls(2)
					disp_UpdatePanelControls(-1)
					break
				// tab 3
				case "buttonRedoColor_tab3":
					ControlInfo/W=$k_fullpanel popupScaleBar_tab3
					disp_ShowScaleBar(v_value-1)
					break
				case "buttonDoCPrint_tab3":
					T3_CreateContactPrintLayout()
					break
				case "buttonClearAll_tab3":
					T3_ClearAllContactPrintImages()
					disp_UpdateTab3()
					break				
			endswitch
			disp_UpdatePanelControls(-1)
		case -1: // control being killed
			break
	endswitch
	
	return 0
end

// slider procedure
Function X_SliderProc(sa) : SliderControl
	STRUCT WMSliderAction &sa

	variable bd
	
	switch( sa.eventCode )
		case -3: // Control received keyboard focus
		case -2: // Control lost keyboard focus
		case -1: // Control being killed
			break
		default:
			strswitch(sa.ctrlName)
				case "slidermagdhist_tabM":
					if( sa.eventCode & 1 ) // value set
						Scale_DHistogram(sa.curval)
					endif
					break
				case "sliderIMin_CB":
					if( sa.eventCode & 1 ) // value set
						bd = Change_DisImageBitDepth(-1)
						move_HistCursor(-1,bd)
					endif
					break
				case "sliderIMax_CB":
					if( sa.eventCode & 1 ) // value set
						bd = Change_DisImageBitDepth(1)
						move_HistCursor(1,bd)
					endif
					break
			break
			endswitch
	endswitch

	return 0
end

// popmenu procedure
Function X_PopMenuProc(pa) : PopupMenuControl
	STRUCT WMPopupAction &pa

//	variable shiftkey = pa.eventMod == 2 ? 1 : 0
	
	switch( pa.eventCode )
		case 2: // mouse up
			if (!X_PopHasChanged(pa))
//				if (shiftkey)
//					strswitch(pa.ctrlName)
//						case "popupFile_tabM":
//							print "shift key on file"
//							break
//					endswitch
//				endif
				return 0
			endif
			strswitch(pa.ctrlName)
				// control bar
				case "popupSplit_CB":				
					disp_SplitWindow(pa.popNum)
					disp_UpdateControlBar()
					disp_UpdatePanelControls(-1)
					ControlInfo/W=$k_fullpanel tab_main
					disp_UpdatePanelControls(v_value)
					break
				case "popupColor_CB":
					ModifyImage $f_CurrentImage(), ctab={,,$pa.popStr,0}
					if (f_isSplit())
						ModifyImage $f_SplitWindowImage(), ctab={,,$pa.popStr,0}
					endif
					break
				// tab M
				case "popupFolder_tabM":
					// change to a new folder
					disp_SplitWindow(0)
					step_ThruImages(0)
					disp_UpdateControlBar()
					disp_UpdatePanelControls(-1)
					ControlInfo/W=$k_fullpanel tab_main
					disp_UpdatePanelControls(v_value)
					T3_UpdateContactPrint()
					break
				case "popupFile_tabM":
					// change to a new file
					reset_CWImageFileName(pa.popStr)
					step_ThruImages(0)
					//disp_ResetImageFileonPanel()
					disp_UpdateControlBar()
					disp_UpdatePanelControls(-1)
					ControlInfo/W=$k_fullpanel tab_main
					disp_UpdatePanelControls(v_value)
					T3_UpdateContactPrint()
					break
				case "popupWhatInfo_tabM":
					disp_UpdateInfo(pa.popNum)
					break
				case "popupHistRoI_tabM":
					Generate_Histograms(pa.popNum-1)
					disp_UpdateTabM()
					break
				case "popupBitDepth_tabM":
					rescale_BitDepth(pa.popNum)
					pa.userdata = ""
					disp_UpdateTabM()
					break
				// tab 0
				case "popupload_tab0":
					disp_UpdatePanelControls(0)
					break
				// tab 1
				case "popupmethodxy_tab1":
					T1_SetXYMethod(pa.popNum)
					disp_UpdatePanelControls(1)
					break
				case "popupmethodcalI_tab1":
					disp_UpdatePanelControls(1)
					break
				// tab 20
				case "popupProcess_tab20":
					disp_updateTab2()
					break
				// tab 21 - remove background
				case "popupbckghow_tab21":
					T21_SetBckgrndHow(pa.popNum)
					T21_SetBackgroundPoints()
					disp_UpdateTab21()
					break
				case "popupBckgPntColor_tab21":
					T21_SetBckgPntColor()
					break
				// tab 22 - apply threshold
				case "popupThRoI_tab22":
					disp_UpdatePanelControls(2)
					break
				case "popupThresMethod_tab22":
					ControlInfo/W=$k_fullpanel checkAutoThreshold_tab22
					if (v_value)
						T22_StartThreshold()
					endif
					disp_UpdatePanelControls(2)
					break
				case "popupThMask_tab22":
					ControlInfo/W=$k_fullpanel checkAutoThreshold_tab22
					if (v_value)
						T22_StartThreshold()
					endif
					disp_UpdatePanelControls(2)
					break
				case "popupThresOnPlane_tab22":
					ControlInfo/W=$k_fullpanel checkAutoThreshold_tab22
					if (v_value)
						T22_StartThreshold()
					endif
					disp_UpdatePanelControls(2)
					break
				// tab 23 - mask regions
				case "popupMaskOPHow_tab23":
				case "popupMaskOPLevel_tab23":
					disp_UpdatePanelControls(2)
					break
				// tab 24 - stack math
				case "popupMaSHow_tab24":
					disp_updateTab24()
					break
				// tab 25 - split math
				case "popupSpMaHow_tab25":
					disp_updateTab25()
				// tab 26 - crop
				case "popupCropHow_tab26":
//					disp_updateTab26()
					break
				// tab 3
				case "popupSBColor_tab3":
					ControlInfo/W=$k_fullpanel popupScaleBar_tab3
					if (v_value > 1)
						disp_SetScaleBarColor(pa.popStr)
					else
						PopupMenu popupSBColor_tab3, win=$k_fullpanel, disable=2
					endif
					T3_UpdateContactPrint()
					break
				case "popupScaleBar_tab3":
					disp_ShowScaleBar(pa.popNum - 1)
					T3_UpdateContactPrint()
					disp_UpdateTab3()
					break
			endswitch
			break
		case -1: // control being killed
			break
	endswitch

	return 0
end

// check whether popup has been changed
// uses userdata
// returns 1 when changed or 0 when not
Function X_PopHasChanged(pa)
	STRUCT WMPopupAction &pa
	
	if (cmpstr(pa.popStr,pa.userdata)==0)
		return 0
	else
		pa.userdata = pa.popStr
		return 1
	endif
end

// checkbox procedure
Function X_CheckProc(cba) : CheckBoxControl
	STRUCT WMCheckboxAction &cba

	variable pv
	switch( cba.eventCode )
		case 2: // mouse up
			strswitch(cba.ctrlName)
				// control bar
				case "checkNumbers_CB":
					disp_ShowHideCBNumbers(cba.checked)
					break
				case "checkMaxRange_CB":
					// reset maximum range
					//ControlInfo/W=$k_imgDisplay sliderIMax_CB
					pv = Change_DisImageBitDepth(1)
					move_HistCursor(1,pv)
					break
				case "checkBW_CB":
					Change_DisImageBitDepth(-2)
					break
				case "checkInvert_CB":
					Change_DisImageBitDepth(0)
					break
				// tab M
				case "checklockhRoI_tabM":
					lock_HistogramRoI(cba.checked)
					//disp_SetHRoIControls(cba.checked)
					//disp_UpdatePanelControls(-1)
					break
				case "checkshowhist_tabM":
					disp_ShowHideHistograms(!cba.checked)
					disp_UpdatePanelControls(-1)
					break
				// tab 0
				case "checkasstack_tab0":
				case "checkasfolder_tab0":
				case "checkgraw_tab0":
				case "checkgred_tab0":
				case "checkggreen_tab0":
				case "checkgblue_tab0":
				case "checkggray_tab0":
					disp_UpdateTab0()
					break
				// tab 1
				case "checkAsBackground_tab1":
					disp_UpdatePanelControls(1)
					break
				// tab 22 - apply threshold
				case "checkAutoThreshold_tab22":
					if (cba.checked)
						T22_StartThreshold()
					endif
					disp_UpdatePanelControls(2)
					disp_UpdatePanelControls(-1)
					break
				// tab 3
				case "checkshowAxes_tab3":
					disp_ShowAxes(cba.checked)
					T3_UpdateContactPrint()
					break
				case "checkCP_tab3":
					switch(cba.checked)
						case 0:
							T3_RemoveContactPrint()
							break
						case 1:
							T3_StoreasContactPrint()
							break
					endswitch
					T3_UpdateContactPrint()
					disp_UpdateTab3()
					break
				case "checkdynamic_tab3":
					T3_UpdateContactPrint()
					break
				case "checkwithtag_tab3":
					T3_UpdateContactPrint()
					break
			endswitch
			break
		case -1: // control being killed
			break
	endswitch
	
	// return active state to panel
	DoWindow/F $k_panelName

	return 0
end

// set variable procedure
Function X_SetVarProc(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	variable bd
	// current only used to take notes to images
	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			strswitch(sva.ctrlName)
				// control bar
				case "setvarIMin_CB":
					bd = Change_DisImageBitDepth(-1)
					move_HistCursor(-1,bd)
					break
				case "setvarIMax_CB":
					bd = Change_DisImageBitDepth(1)
					move_HistCursor(1,bd)
					break
				// tab M
				case "setvarSN_tabM":
					step_ThruImages(0,plane=sva.dval)
					disp_SplitWindow(-1)
					T3_UpdateContactPrint()
					disp_UpdatePanelControls(-1)
					break
				case "setvarImgNote_tabM":
					set_ImageNote()
					break
				case "mqx0_tabM":
				case "mqy0_tabM":
				case "mqdx_tabM":
				case "mqdy_tabM":
					change_MQfromPanel()
					break
				// background
				case "setvarplorder_tab21":
//					PopupMenu popupBckNegs_tab21, win=$k_fullPanel, disable=(sva.dval==0)
//					PopupMenu popupBckgPntColor_tab21, win=$k_fullPanel, disable=(sva.dval==0)
//					PopupMenu popupBckgHow_tab21, win=$k_fullPanel, disable=(sva.dval==0)
					Button buttonRemoveBckg_tab21, win=$k_fullPanel, disable=2*(sva.dval!=0)
					break
				// tab 22 - apply threshold
				case "setvarThresLevel_tab22":
				case "setvarThresRange_tab22":
					// reset threshold level on histogram graph for manual method
					ControlInfo/W=$k_fullpanel popupThresMethod_tab22
					if (v_value == 1)
						string thlevels = StringFromList(1,SortList(TraceNameList(k_histgraphs,";",1)))
						Cursor/W=$k_histgraphs A, $thlevels, sva.dval										
						SetVariable setvarThresLevel_tab22, win=$k_fullpanel, value=_NUM:(xcsr(A,k_histgraphs))
					endif
					// autocalculate new threshold if desired
					ControlInfo/W=$k_fullpanel checkAutoThreshold_tab22
					if (v_value)
						T22_StartThreshold()
					endif
					break
				case "setvarbckgmargin_tab21":
				case "setvarbckgx_tab21":
				case "setvarbckgy_tab21":
					T21_ClearBackgroundPoints()
					T21_SetBackgroundPoints()
					break
			endswitch
			break
		case -1: // control being killed
			break
	endswitch

	return 0
end

// put a date+time stamp
// [dsep] - in date; [tsep] - in time; [dtsep] - between date and time
Function/S f_DateTimeStamp([dsep, tsep, dtsep])
	string dsep, tsep, dtsep
 
	string a, b, c, dstr, tstr, gExp
 
	if (ParamIsDefault(dsep))
		dsep = "-"
	endif
	if (ParamIsDefault(tsep))
		tsep = ":"
	endif
	if (ParamIsDefault(dtsep))
		dtsep = "/"
	endif
 
	gExp = "([0-9]+):([0-9]+)"	
	SplitString/E=(gExp) secs2time(datetime,2), a, b
	tstr = a + tsep + b
 
	gExp = "([0-9]+)/([0-9]+)/([0-9]+)"	
	SplitString/E=(gExp) secs2date(datetime,-1), a, b, c
	dstr = c[2,3] + dsep + b + dsep + a
 
	return (dstr + dtsep +  tstr) 
end

// is the image window split?
Function f_IsSplit()
	
	variable isT, isL, vrtn
	GetAxis/W=$k_imgDisplay/Q splitT
	isT = v_flag
	GetAxis/W=$k_imgDisplay/Q splitL
	isL = v_flag
	vrtn = (!isL || !isT)
	return vrtn
end

Function f_PrintNtbk()

	ControlInfo/W=$k_fullpanel checkprintntbk_tabM
	return v_value
end

// what is in the split window?
Function/S f_SplitWindowImage()

	string swstr = ""
	swstr = ImageNameList(k_imgDisplay,";")
	
	if (ItemsInList(swstr) > 1)
		swstr = StringFromList(1,swstr)
	else
		swstr = ""
	endif

	return swstr
end

// a threshold wave exists
Function f_ThresholdExists([variable specific])

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string lofiles, spfile, ffile
	variable index = -1
	
	lofiles = f_LoimgF(sfolder=cwdfolder,all=1)
	
	// search for specific file
	spfile = cwfile[4,inf]+"_th"
	ffile = StringFromList(0,ListMatch(lofiles,spfile))
	if (strlen(ffile) != 0)
		index = WhichListItem(ffile,lofiles)
	else
		if (ParamIsDefault(specific))
			// search for any file
			spfile = cwfile[4,inf] + "*_th"
			ffile = StringFromList(0,ListMatch(lofiles,spfile))
			if (strlen(ffile) != 0)	
				index = WhichListItem(ffile,lofiles)
			endif
		endif		
	endif
	return index
end

// is this a threshold?
Function f_isThreshold()

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile
	
	variable ps, sl
	sl = strlen(cwfile)
	ps = strsearch(cwfile,"_th",0)
	if (ps + 4 > sl)
		return 1
	endif
	return 0
end

// a fill wave exists
// 0 no, 1 directly, >1 after threshold
Function f_FillExists([variable specific])

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string lofiles, spfile, ffile
	variable index = -1
	
	lofiles = f_LoimgF(sfolder=cwdfolder,all=1)
	
	// search for specific file
	spfile = cwfile[4,inf]+"_fl"
	ffile = StringFromList(0,ListMatch(lofiles,spfile))
	if (strlen(ffile) != 0)
		index = WhichListItem(ffile,lofiles)
	else
		if (ParamIsDefault(specific))
			// search for any file
			spfile = cwfile[4,inf] + "*_fl"
			ffile = StringFromList(0,ListMatch(lofiles,spfile))
			if (strlen(ffile) != 0)
				index = WhichListItem(ffile,lofiles)
			endif
		endif		
	endif
	return index
end

// is this a fill?
// return 0 - not a fill, 1 - a fill, 2 - a fill on a threshold
Function f_isFill()

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile
	
	variable psf, pst, sl
	sl = strlen(cwfile)
	pst = strsearch(cwfile,"_th",0)
	psf = strsearch(cwfile,"_fl",0)
	if (psf + 4 > sl)
		if ((psf - pst)!= 3)
			return 1
		else
			return 2
		endif
	endif
	return 0
end

// is this a background?
Function f_isBackground()

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile
	
	if (strsearch(cwfile,"_bg",0)==-1)
		return 0
	else
		return 1
	endif
end

// is an image loaded?
Function f_ImageLoaded()

	string st = f_LoFolders(cstr="imgT_*")

	if (strlen(st)==0)
		return 0
	else
		return 1
	endif
end

// return string for working data folder or image name
Function/S f_wdfstr(variable which)

	// globals
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string wdf = "root:" + cwdfolder
	switch(which)
		case 1:
			wdf += ":" + cwfile
			break
	endswitch
	
	return wdf
end

// return wave reference to image being displayed
Function/WAVE f_imgwaveDisplayed()

	string wdf = f_wdfstr(0)
	string ifile = f_wdfstr(1)
	
	wave/SDFR=$wdf wref = $ifile

	return wref
end

// image id information
// 0 - cwdfolder + cwfile + : plane number
// 1 - cwdfolder
// 2 - cwfile
// 3 - full path to source
// 4 - full path to split
// 5 - split file name
// -1 - eliminate threshold or fill
Function/S f_DisplayImageID(how)
	variable how

	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string rfile
	switch(how)
		case -1:
			rfile = ReplaceString("_th",cwfile,"")
			rfile = ReplaceString("_fl",rfile,"")
			break
		case 0:
			rfile = cwdfolder + ":" + cwfile + ":" + num2str(f_PlaneNumber())
			break
		case 1:
			rfile = cwdfolder
			break
		case 2:
			rfile = cwfile
			break
		case 3:
			rfile = "root:" + cwdfolder + ":" + cwfile
			break
		case 4:
			if (!f_IsSplit())
				rfile = ""
			endif
			rfile = "root:" + cwdfolder + ":" + StringFromList(1,ImageNameList(k_imgDisplay,";"))
			break
		case 5:
			if (!f_IsSplit())
				rfile = ""
			endif
			rfile = StringFromList(1,ImageNameList(k_imgDisplay,";"))
			break
	endswitch
	return rfile
end

// number of image sets loaded
Function f_NImagesLoaded()

	variable ni
	ni = ItemsInList(f_LoImgT())
	return ni
end

// options to show in split window
Function/S f_SplitOptions([variable full])

	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string mStr = "None;"
	string wdf = "root:" + cwdfolder	
	string flist = ""
	
	DFREF cwdf = $wdf	

	flist = DataFolderDir(2,cwdf)
	flist = ReplaceString("WAVES:",flist,"")
	flist = ReplaceString(",",flist,";")
	flist = ListMatch(flist,"img_*")
	flist = SortList(flist,";",0)
	if (ParamIsDefault(full))
		flist = ReplaceString(cwfile,flist,"\\M1("+cwfile,0,1)
		mStr += ReplaceString("img_",flist,"")
	else
		mStr += flist
	endif
	
	return mStr
end

// current file is stack
Function f_isStack()

	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string imgFile = "root:" + cwdfolder + ":" + cwfile
	variable rtnv = 0
	
	if (DimSize($imgFile,2)>0)
		rtnv = 1
	endif
	
	return rtnv
end

// number of images in stack
Function f_NImagesinStack()

	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable ni
	string imgFile = "root:" + cwdfolder + ":" + cwfile
	
	ni = DimSize($imgFile,2)
	if (numtype(ni)!=0)
		ni = 0
	endif
	return ni
end

// current plane number being viewed in stack
Function f_PlaneNumber()

	variable pl = 0
	string info, plstr
	
	if (f_isStack())
		info = ImageInfo(k_imgDisplay,"",0)
		plstr = StringByKey("plane", info,"=")
		pl = str2num(plstr)
	endif
	
	return pl
end

// list of imgT folders
Function/S f_LoImgT()

	DFREF cdf = GetDataFolderDFR()

	SetDataFolder root:
	string lof = f_LoFolders(cstr="imgT_*")
	SetDataFolder cdf
	
	lof = ReplaceString("imgT_",lof,"")
//	if (strlen(lof) == 0)
//		lof = "None;"
//	endif
	return lof
end

// return the image note for the current display
Function/S f_ImageNoteText()

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string wname = "root:" + cwdfolder + ":" + cwfile
	
	wave/Z ww = $wname
	if (!WaveExists(ww))
		return ""
	endif
	
	return (note($wname))
end

// image size
// 0 - method
// 1 - width (pixels)
// 2 - height (pixels)
// 3 - width (meters)
// 4 - height (meters)
// 5 - meters/pixel
// 6 - width x height (pixels^2)
// 7 - left
// 8 - top
Function/WAVE f_ImageSize()

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	variable xpixels, ypixels
	
	string wname = "root:" + cwdfolder + ":" + cwfile
	xpixels = DimSize($wname,0)
	ypixels = DimSize($wname,1)
	
	make/N=9/FREE/D rwave
	rwave[1] = xpixels
	rwave[2] = ypixels
	rwave[6] = xpixels*ypixels
	rwave[7] = DimOffset($wname,0)
	rwave[8] = DimOffset($wname,1)

	// check for scale for image
	STRUCT S_CalibrateVariables scv
	// pixels (no local or global scaling)
	if (Sf_RecallCalibrateVariables(scv)==-1)
		rwave[0] = 0
		rwave[3] = NaN
		rwave[4] = NaN
		rwave[5] = NaN
	else
		rwave[0] = scv.xyhow
		rwave[3] = scv.xyiwidth
		rwave[4] = scv.xyiheight
		rwave[5] = scv.mpp
	endif
	return rwave
end

// return the image size for the current display
Function/S f_ImageSizeText()

	variable xcal = f_ImageSize()[0]
	string rtstr = ""
	
	switch(xcal)
		case 0:		// no scaling
			sprintf rtstr, "%d x %d [pixels]", f_ImageSize()[1], f_ImageSize()[2]
			break
		default:
			sprintf rtstr, "%.3e x %.3e [m]", f_ImageSize()[3], f_ImageSize()[4]
			break
	endswitch
	
	return rtstr
end

// list of threshold RoIs 
Function/S f_ThRoIs()

	string rtstr = "Full;"
	
	STRUCT S_MarqueeCoordinates mq
	Sf_GetMQCoordinates(mq)

	if (mq.hasmarquee == 1)
		rtstr += "[>T<];T<[ ]>T;"
	else
		rtstr += "\\M0:(:[>T<];\\M0:(:T<[ ]>T;"	
	endif
	
	return rtstr
end

// maximum of current image
Function f_CurrImageMax()

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string iname

	iname = "root:" + cwdfolder + ":" + cwfile
	wave cdimg = $iname

	return wavemax(cdimg)
end

// return maximum value of current displayed image
Function f_DisplayedImageMax()

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable rtn, cplane
	string iname
	
	iname = "root:" + cwdfolder + ":" + cwfile
	wave cdimg = $iname

	if (f_IsStack())
		cplane = f_PlaneNumber()
		MatrixOP/FREE cdfimg = cdimg[][][cplane]
		rtn = wavemax(cdfimg)
	else
		rtn = wavemax(cdimg)
	endif
	
	return rtn
end

// return the bit depth of the current image
Function f_ImageBitDepth([simgname])
	string simgname

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable bitd, wtype
	string wname = ""
	
	if (!ParamIsDefault(simgname))
		wname = simgname
	else
		wname = "root:" + cwdfolder + ":" + cwfile
	endif
	wtype = WaveType($wname,0)
	
	if (wtype & 2)		// 32 bit float
		bitd = 32
	elseif (wtype & 4)	// 64 bit float
		bitd = 64
	elseif (wtype & 0x08)
		bitd = 8		// 8 bit
	elseif (wtype & 0x10)
		bitd = 16		// 16 bit
	endif
	
	return bitd
end

// list of folders in a sdfr following a cstr string convention
Function/S f_LoFolders([sdfr,cstr])
	string cstr
	DFREF sdfr
	
	if (!ParamIsDefault(sdfr))
		SetDataFolder sdfr
	endif
	
	string tstr = "", lstr = ""
	variable ic
	do
		tstr = GetIndexedObjName("",4,ic)
		if (strlen(tstr)==0)
			break
		else
			lstr += tstr + ";"
		endif
		ic += 1
	while (1)
	
	if (!ParamIsDefault(cstr))
		lstr = ListMatch(lstr,cstr,";")
	endif
	
	return lstr
end

// image files in a given folder
Function/S f_LoimgF([string sfolder, variable all, variable full])

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder
	
	string lfiles = "", csplitimg
	
	if (!ParamIsDefault(sfolder))
		lfiles = "root:" + sfolder
	else
		lfiles = "root:" + cwdfolder
	endif
	
	DFREF imgF = $lfiles
	DFREF cdf = GetDataFolderDFR()
	SetDataFolder imgF
	lfiles = WaveList("img_*",";","")
	lfiles = SortList(lfiles,";",0)
	SetDataFolder cdf
	if (ParamIsDefault(all))
		if (f_IsSplit())
			ControlInfo/W=$k_imgDisplay popupSplit_CB
			csplitimg = "img_"+s_value
			lfiles = ReplaceString(csplitimg,lfiles,"\\M1("+csplitimg,1,1)
		endif
	endif
	if (ParamIsDefault(full))
		lfiles = ReplaceString("img_",lfiles,"")
	endif
	
	return lfiles
end

// has XY scale
// 0 - global, 1 - local
Function f_HasXYScale(where)
	variable where
	
	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder
	string wf

	switch(where)
		case 0:		// global
			wf = k_fullpackageFolder + ":imgT_processvariables"	
			break
		case 1:		// local
			wf = "root:" + cwdfolder + ":imgT_processvariables"	
			break
	endswitch
	if (DataFolderExists(wf))
		return 1
	else
		return 0
	endif
end

// checks whether the current image is already a contact print storage
Function f_IsContactPrint()

	// global values
	DFREF cpf = $k_fullpackageFolder + ":contactprint"
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable tf=0, ic=0, cplane = f_isStack() ? f_PlaneNumber() : 0
	string cpstr,cpritem
	
	if (f_CountofContactPrints()==0)
		return tf
	endif
	
	cpstr = cwdfolder[5,inf] +"_" + cwfile
	if (f_isStack())
	 cpstr += "_" + num2str(f_PlaneNumber())
	endif
	
	do
		cpritem = GetIndexedObjNameDFR(cpf,3,ic)
		if (strlen(cpritem)==0)
			break
		endif
		if (cmpstr(cpstr,cpritem)==0)
			tf = 1
			break
		endif
		ic += 1
	while(1)

	return tf
end

Function f_LayoutIsDynamic()
	ControlInfo/W=$k_fullpanel checkdynamic_tab3
	return v_value
end

// counts the number of contact prints stored
Function f_CountofContactPrints()

	// global values
	DFREF cpf = $k_fullpackageFolder + ":contactprint"
	
	variable cnt = 0
	
	if (DataFolderExists(k_fullpackageFolder + ":contactprint"))
		cnt = CountObjectsDFR(cpf,3)
	else
		cnt = -1
	endif
	
	return cnt
end

// image RGB setting
Function f_imgRGB([thisimg])
	wave thisimg

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable iRGB=0
	
	if (ParamIsDefault(thisimg))
		string wname = "root:" + cwdfolder + ":" + cwfile
		wave wimg = $wname
	else
		wave wimg = thisimg
	endif
	if (WaveDims(wimg)	 == 3)
		iRGB = 1
	endif
	return iRGB
end

// string to return list of Histogram options
Function/S f_LoInfoOptions()

	string rtnstr = "None;Histograms;"
	
	if ((f_HasHRoI() > 0) || (f_HasMQ() > 0))
		
		//rtnstr += "Profiles;"
	endif
	
	return rtnstr
end

// string to return list of Histogram options
Function/S f_LoHMRoI()

	string rtnstr = "Full Image;"
	
	if ((f_HasHRoI() > 0) || (f_HasMQ() > 0))		
		rtnstr += "[>H<];H<[ ]>H;[>H<] - H<[ ]>H;H<[ ]>H - [>H<];"
	else
		rtnstr += "\\M0:(:[>H<];\\M0:(:H<[ ]>H;\\M0:(:[>H<] - H<[ ]>H;\\M0:(:H<[ ]>H - [>H<];"
	endif
	
	return rtnstr
end

Function/S f_BckGridOptions()

	string rtnstr = "Set Manually;\\M1( --- Grids ---;Full;"
	if (f_HasMQ())
		rtnstr += "B<[ ]>B;[>B<];B<( )>B;(>B<);"
	else
		rtnstr += "\\M0:(:B<[ ]>B;\\M0:(:[>B<];\\M0:(:B<( )>B;\\M0:(:(>B<);"	
	endif
	if (f_ThresholdExists()>0)
		rtnstr += "\\M1(-;Exclude Threshold White Levels;"
	else
		rtnstr += "\\M1(-;\\M1(Exclude Threshold White Levels;"	
	endif
	if (f_FillExists()>0)
		rtnstr += "Exclude Fill White Levels;"
	else
		rtnstr += "\\M1(Exclude Fill White Levels;"
	endif
	
	return rtnstr
end

// has background marker wave
Function f_HasBckgMrkrs()

	variable hasmarker = 0
	string imgList = TraceNameList(k_imgDisplay,";",1)
	if (FindListItem("imgT_bckgY",imgList) >= 0)
		hasmarker = 1
	endif
	
	return hasmarker
end

Function f_HasStoredBckgrnd()

	variable hassb = 0
	
	string cwdfstr = f_DisplayImageID(1)
	DFREF cwdf = $cwdfstr
	
	string bstr = "root:" + cwdfstr + ":imgT_background"
	
	if (DataFolderExists(bstr))
		hassb = 1
	endif
	
	return hassb
end

// has global background markers stored
Function f_HasGlobalBckgMrkrs()

	// global values
//	DFREF pf = $k_fullpackageFolder

	variable hasmarker = 0
	string imgList = TraceNameList(k_imgDisplay,";",1)
	if (FindListItem("imgT_bckgY",imgList) < 0)
		hasmarker = 0
	else
		hasmarker = 1
	endif
	
	return hasmarker
end

// has marquee
Function f_HasMQ()

	string vmq = k_fullpackageFolder + ":hasMQ"
	variable/G $vmq
	NVAR hasMQ = $vmq
	
	GetMarquee/W=$k_imgDisplay/Z
	hasMQ = v_flag
	
	return hasMQ
end

// marquee has moved
// 0 - same postion
// 1 - created or moved
// -1 - killed from previous existence
Function f_MQHasMoved()

	DFREF pf = $k_fullpackageFolder
	NVAR/SDFR=pf/Z hasMQ
	
	variable rtn
	string MQgsize
	STRUCT S_MarqueeCoordinates mc
	
	GetMarquee/W=$k_imgDisplay/Z
	if (v_flag != hasMQ)
		if (v_flag)
			hasMQ = 1
			rtn = 1
		else
			hasMQ = -1
			rtn = -1
		endif
	else
		Sf_GetMQCoordinates(mc)
		MQgsize = GetUserData(k_imgDisplay,"","MQSize")
		rtn = !StringMatch(MQgsize,mc.pgsize)
		hasMQ = rtn
	endif
#ifdef DEBUG
	print "MQ Moved ", rtn
#endif
	return rtn
end

// has histogram drawing RoI
Function f_HasHRoI()

	DrawAction/W=$k_imgDisplay/L=ProgFront getgroup=hRoI, extractOutline
	return (v_flag)
end

// has drawing for mask process operations
Function f_HasMaskRoI()

	DrawAction/W=$k_imgDisplay getgroup=MaskRoIs, commands
	return v_flag
end

// has drawing for mask process operations
Function f_ShowToolsState()

	variable index
	index = WhichListItem("ShowTools",WinRecreation(k_imgDisplay,4),"\r\t")
	return index
end

// what is the current image?
Function/S f_CurrentImage()
	
	string cImage = ImageNameList(k_imgDisplay,"")
	cImage = ListMatch(cImage,"!RP_*")
	cImage = StringFromList(0,cImage)
	return cImage
end

// delta of cursors: 1-dx, 2-dx in m, 3-dy
Function f_MQCursorDelta(how)
	variable how

	variable vrtn
	string cstr
	
	return 0
	
	switch(how)
		case 0:		// dx		
			cstr = CsrInfo(B,k_fullmqprofile)
			vrtn = NumberByKey("POINT",cstr)
			cstr = CsrInfo(A,k_fullmqprofile)
			vrtn -= NumberByKey("POINT",cstr)
			break
		case 1:		// dx m	
			cstr = CsrInfo(B,k_fullmqprofile)
			vrtn = NumberByKey("POINT",cstr)
			cstr = CsrInfo(A,k_fullmqprofile)
			vrtn -= NumberByKey("POINT",cstr)
			vrtn *= f_ImageSize()[5]
			break
		case 2:		// dy
			vrtn = vcsr(B,k_fullmqprofile)
			vrtn -= vcsr(A,k_fullmqprofile)
			break
	endswitch
	
	return vrtn
end

Function f_StackOKtoThreshold()

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	variable rtnv = 1
	string bfile, sfile, sfldr
	
	if (f_IsBackground())
		bfile = ReplaceString("_th",cwfile,"")
		sfldr = "root:" + cwdfolder
		wave/SDFR=$sfldr bimg = $bfile
		Make/N=(f_NImagesinStack())/FREE iMaxValues
		MultiThread iMaxValues = f_GetPlaneMax(bimg,p)
		iMaxValues = iMaxValues[p] == 0 ? NaN : iMaxValues[p]
		WaveStats/M=1/Q iMaxValues
		if (V_numNaNs > 0)
			rtnv = 0
		endif
	endif
	
	return rtnv
	
end

ThreadSafe Function f_GetPlaneMax(ww,pp)
	wave ww
	variable pp
	
	MatrixOP/FREE maxvalpp = maxVal(layer(ww,pp))
		
	return maxvalpp[0]
end

// raw image?
Function f_IsRawImage()

	variable vrtn = 1, ic = 0
	
	string cwf = f_DisplayImageID(2)
	string exlist = "*_th*;*_bg*;*_nbh*;*_nbf*;*_msk*;"
	
	for(ic=0;ic<5;ic+=1)
		if (StringMatch(cwf,StringFromList(ic,exlist)) == 1)
			vrtn = 0
			break
		endif
	endfor
	
	return vrtn
end

// bit depth controls
Function/S f_LoBitDepths()

	string rstr = ""
	variable bd = f_ImageBitDepth()

	switch(bd)
		case 8:
			rstr = "8;\\M1(12;\\M1(16;\\M1(32;\\M1(64;"
			break
		case 12:
			rstr = "\\M1(8;12;\\M1(16;\\M1(32;\\M1(64;"
			break
		case 16:
			rstr = "\\M1(8;\\M1(12;16;\\M1(32;\\M1(64;"
			break
		case 32:
			rstr = "\\M1(8;\\M1(12;\\M1(16;32;\\M1(64;"
			break
		case 64:
			rstr = "\\M1(8;\\M1(12;\\M1(16;\\M1(32;64;"
			break
	endswitch
	
	return rstr
end

// return bit depth as popup menu mode
Function f_PBitDepth()

	variable bd = f_ImageBitDepth()
	variable rtnv = 1
	
	switch(bd)
		case 12:
			rtnv = 2
			break
		case 16:
			rtnv = 3
			break
		case 32:
			rtnv = 4
			break
		case 64:
			rtnv = 5
			break
	endswitch
	
	return rtnv
end
